local shader = love.graphics.newShader([[
    // written by groverbuger for g3d
    // september 2021
    // MIT license
    
    
    // this vertex shader is what projects 3d vertices in models onto your 2d screen
    
    uniform mat4 projectionMatrix; // handled by the camera
    uniform mat4 viewMatrix;       // handled by the camera
    uniform mat4 modelMatrix;      // models send their own model matrices when drawn
    uniform bool isCanvasEnabled;  // detect when this model is being rendered to a canvas
    
    // define some varying vectors that are useful for writing custom fragment shaders
    varying vec4 worldPosition;
    varying vec4 viewPosition;
    varying vec4 screenPosition;
    varying vec3 vertexNormal;
    varying vec4 vertexColor;
    
    
    
    #ifdef VERTEX
    // the vertex normal attribute must be defined, as it is custom unlike the other attributes
    attribute vec3 VertexNormal;
    vec4 scramble(vec4 v, float radius, float t);
    
    vec4 position(mat4 transformProjection, vec4 vertexPosition) {
        // save some data from this vertex for use in fragment shaders
        vertexNormal = VertexNormal;
        vertexColor = VertexColor;
    
        // calculate the positions of the transformed coordinates on the screen
        // save each step of the process, as these are often useful when writing custom fragment shaders
        worldPosition = modelMatrix * vertexPosition;
        viewPosition = viewMatrix * worldPosition;
        screenPosition = projectionMatrix * viewPosition;
    
        // for some reason models are flipped vertically when rendering to a canvas
        // so we need to detect when this is being rendered to a canvas, and flip it back
        if (isCanvasEnabled) {
            screenPosition.y *= -1.0;
        }
    
        return screenPosition;
    }
    #endif
    
    #ifdef PIXEL
    vec4 effect(vec4 color, Image tex, vec2 texture_coords, vec2 screen_coords){
      return color*Texel(tex,texture_coords);
    }
    #endif 
]])
return shader