import logging, sys

class ColoredFormatter(logging.Formatter):
    DEBUG = "\x1b[36;20m"
    INFO = "\x1b[38;20m"
    WARNING = "\x1b[33;20m"
    ERROR = "\x1b[31;20m"
    CRITICAL = "\x1b[31;1m"
    _format = "%(color)s[%(asctime)s]\x1b[0m <%(user)s> %(message)s"

    def get_colors(self):
        return {
            logging.DEBUG: self.DEBUG,
            logging.INFO: self.INFO,
            logging.WARNING: self.WARNING,
            logging.ERROR: self.ERROR,
            logging.CRITICAL: self.CRITICAL
        }

    def __init__(self, format=_format):
        self._format = format

    def format(self, record):
        record.__dict__.update({"color": self.get_colors()[record.levelno]})
        formatter = logging.Formatter(self._format)
        return formatter.format(record)

def ColoredStream(LOG_LEVEL, *args):
    stream = logging.StreamHandler(sys.stdout)
    stream.setLevel(LOG_LEVEL)
    stream.setFormatter(ColoredFormatter(*args))
    return stream

def FileStream(LOG_LEVEL, file="posts.log", format="[%(asctime)s] <%(user)s> (%(command)s) %(message)s", *args):
    stream = logging.FileHandler(file)
    stream.setLevel(LOG_LEVEL)
    stream.setFormatter(logging.Formatter(format, *args))
    return stream
